#include "ContentList.h"
#include "tools.h"
#include <algorithm>
#include "freestyledash.h"
#include <direct.h>

ContentList cl;

ContentList::ContentList(void)
{
	HorizOverscan = 0;
	VertOverscan = 0;
	FanSpeed = 0;
	sub1ProgCur = 0;
	sub1ProgMax = 0;
	sub2ProgCur = 0;
	sub2ProgMax = 0;
	Loaded = false;

	port = 21;
	debugport = 0;
	ftpuser = L"xbox";
	ftppass = L"xbox";
	xboxip = L"0.0.0.0";

	LastRecent = 0;
}

ContentList::~ContentList(void)
{
}

void ContentList::SetCurrent(wstring newtext)
{
	lt->Lock();
	current = newtext;
	lt->Unlock();
}

void ContentList::SetSub1(wstring newtext)
{
	lt->Lock();
	sub1 = newtext;
	lt->Unlock();
}

void ContentList::SetSub2(wstring newtext)
{
	lt->Lock();
	sub2 = newtext;
	lt->Unlock();
}

void ContentList::Initialize()
{
	AnyChanged = false;

	SetCurrent(L"Loading Content XML");
	//Sleep(500);
	LoadContentXML();

	SetCurrent(L"Scanning drives for content");
	//Sleep(500);
	LoadNonXMLItems();

	SetCurrent(L"Removed deleted games");
	//Sleep(500);
	ClearDeleted();

	SetCurrent(L"Loading Favourites");
	//Sleep(500);
	LoadFavourites();

	SetCurrent(L"Converting strings");
	//Sleep(500);
	ConvertAllToWide();

	SetCurrent(L"Building Genre List");
	//Sleep(500);
	BuildGenreList();

	SetCurrent(L"Sorting");
	//Sleep(500);
	SortAll();
	
	SetCurrent(L"Saving Content List For Indexer");
	if (AnyChanged)
	{
		SaveContentList();
	} else {
		DebugMsg("Not saving content - no changes");
	}


	Loaded = true;

}

void ContentList::ConvertAllToWide()
{
	vector<ContentItem*>::iterator itr;
	for (itr = Content.begin() ; itr != Content.end() ; itr++)
	{
		(*itr)->CreateWStrs();
	}
}

void ContentList::SaveContentList()
{
	FILE * fp = NULL;
	_wfopen_s(&fp,wstring(datapath + L"content.xml").c_str(),L"w");
	if (fp == NULL)
	{
		DebugMsg("Unable to create content.xml");
		return;
	}

	vector<ContentItem*>::iterator itr;

	wstring temp = L"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
	temp.reserve(500000);
	//fwrite(temp.c_str(),temp.size()*2,1,fp);

	temp.append(L"<freestyle>\n");
	//fwrite(temp.c_str(),temp.size()*2,1,fp);

	sub1ProgMax = Content.size();
	sub1ProgCur = 0;

	for (itr = Content.begin() ; itr != Content.end() ; itr++)
	{
		sub1ProgCur++;

		temp.append(sprintfa(L"\t<game type='%d'>\n",(*itr)->type));
		temp.append(sprintfa(L"\t\t<id>%s</id>\n",(*itr)->id.c_str()));
		temp.append(sprintfa(L"\t\t<title>%s</title>\n",(*itr)->title.c_str()));
		temp.append(sprintfa(L"\t\t<path>%s</path>\n",(*itr)->path.c_str()));
		temp.append(sprintfa(L"\t\t<desc>%s</desc>\n",(*itr)->desc.c_str()));
		temp.append(sprintfa(L"\t\t<imgpath>%s</imgpath>\n",(*itr)->imagefolder.c_str()));
		temp.append(sprintfa(L"\t\t<images sscount='%d' icon='%d' boxart='%d' background='%d' />\n",(*itr)->i_SSCount,(int)(*itr)->i_Icon,(int)(*itr)->i_BoxArt,(int)(*itr)->i_Background));
		temp.append(sprintfa(L"\t\t<mediaid>%d</mediaid>\n",(*itr)->mediaid.c_str()));
		temp.append(sprintfa(L"\t\t<manufacturer>%s</manufacturer>\n",(*itr)->manuf.c_str()));
		temp.append(sprintfa(L"\t\t<disks no='%d' count='%d' />\n",(*itr)->discno,(*itr)->disccn));
		temp.append(sprintfa(L"\t\t<version>%d</version>\n",(*itr)->version));

		
		temp.append(sprintfa(L"\t\t<custom c_type='%d' />\n",(*itr)->c_type));
		temp.append(L"\t\t<genres>\n");

		vector<wstring>::iterator gi;
		for (gi = (*itr)->genres.begin() ; gi != (*itr)->genres.end() ; gi++)
		{
			temp.append(sprintfa(L"\t\t\t<genre>%s</genre>\n",(*gi).c_str()));
		}

		temp.append(L"\t\t</genres>\n");
		temp.append(L"\t</game>\n");

		//fwrite(temp.c_str(),temp.size()*2,1,fp);
	}

	temp.append(L"</freestyle>\n");
	//fwrite(temp.c_str(),temp.size(),1,fp);

	int neededbuffer = WideCharToMultiByte(CP_UTF8,0,temp.c_str(),-1,NULL,0,NULL,FALSE);
	DebugMsg("Needed buffer : %d",neededbuffer);
	if (neededbuffer == 0)
	{
		fclose(fp);
		return;
	}
	char* buf2 = new char[neededbuffer];
	memset(buf2,0,neededbuffer);
	int res = WideCharToMultiByte(CP_UTF8,0,temp.c_str(),-1,buf2,neededbuffer,NULL,FALSE);
	if (res == 0)
	{
		fclose(fp);
		return;
	}

	fwrite(buf2,1,neededbuffer,fp);

	delete buf2;

	fclose(fp);
}

void ContentList::LoadContentXML()
{
	//int i = 0;
	XMLReader * xml = LoadConfigFile(datapath + L"content.xml");

	if (!xml)
		return;

	sub1ProgMax = xml->GetSize() / 1024;
	sub1ProgCur = 0;
	
	//lock->Lock();
	//lock->Unlock();
	//debugLog("USED PATHS:");
	while (xml && xml->read())
	{
		sub1ProgCur = xml->GetOffset() / 1024;
		if (StartAttribute(xml,L"game"))
		{
			ContentItem * item = new ContentItem();
			item->type = xml->getAttributeValueAsInt(L"type");
			while (!EndAttribute(xml,L"game"))
			{
				if (StartAttribute(xml,L"title"))
				{
					item->title = xml->getSubNodeData();
					/*item->wtitle = new WCHAR[item->title.size() + 2];
					wcscpy(item->wtitle,item->title.c_str());*/
				}
				if (StartAttribute(xml,L"path"))
				{
					item->path = xml->getSubNodeData();
				}
				if (StartAttribute(xml,L"id"))
				{
					item->id = xml->getSubNodeData();
				}
				if (StartAttribute(xml,L"desc"))
				{
					item->desc = xml->getSubNodeData();
				}
				if (StartAttribute(xml,L"imgpath"))
				{
					item->imagefolder = xml->getSubNodeData();
				}
				if (StartAttribute(xml,L"genre"))
				{
					item->genres.push_back(xml->getSubNodeData());
				}
				if (StartAttribute(xml,L"manufacturer"))
				{
					item->manuf = xml->getSubNodeData();
				}
				if (StartAttribute(xml,L"mediaid"))
				{
					item->mediaid = xml->getSubNodeData();
				}
				if (StartAttribute(xml,L"version"))
				{
					item->version = _wtoi(xml->getSubNodeData().c_str());
				}
				if (StartAttribute(xml,L"disks"))
				{
					item->discno = xml->getAttributeValueAsInt(L"no");
					item->disccn = xml->getAttributeValueAsInt(L"count");
				}
				if (StartAttribute(xml,L"images"))
				{
					item->i_SSCount = xml->getAttributeValueAsInt(L"sscount");
					item->i_Icon = xml->getAttributeValueAsBool(L"icon");
					item->i_BoxArt = xml->getAttributeValueAsBool(L"boxart");
					int background = xml->getAttributeValueAsInt(L"background");
					item->i_Background = false; 
					if (background == 1)
						item->i_Background = true;
				}
				if (StartAttribute(xml,L"custom"))
				{
					item->c_type = xml->getAttributeValueAsInt(L"c_type");
					if (item->c_type >= 6)
						item->c_type = item->type;
				}
			}
			//item->wicon = new WCHAR[item->icon.size() + 2];
			//wcscpy(item->wicon,item->icon.c_str());
			//string icon = wstrtostr(item->icon);
			//debugLog(icon.c_str());
			MakeShortPath(item);

			//if (FileExists(item->path))
			//	item->Exist = true;
			//DebugMsg("Lookup path %s",folder.c_str());
			item->source = 1;
			Content.push_back(item);
		}
	}

	FreeXMLAndText(xml);
	sub1ProgMax = 0;
	//DebugMsg("Loaded %d games from content.xml",Content.size());
	//debugLog("END USED PATHS");

}

void ContentList::MakeShortPath(ContentItem * item)
{
	wstring folder = item->path.substr(0,item->path.rfind(L"\\"));
	if (item->type == 0)
	{
		folder = item->id;
	}
	if (item->type == 5)
	{
		folder = item->id;
	}
	folder = make_lowercase(folder);
	item->shortpath = folder;
	//DebugMsg("Making short path for %s -> %s",item->title.c_str(),folder.c_str());
	PathLookup[folder] = item;
}

bool SortContent(const ContentItem * left, const ContentItem * right) 
{ 
	int res = _wcsicmp(left->title.c_str(),right->title.c_str());
	if (res < 0) return true;
	return false;
}

bool SortRecent(const ContentItem * left, const ContentItem * right) 
{ 
	if (left->recent > right->recent) return true;
	if (left->recent < right->recent) return false;
	int res = _wcsicmp(left->title.c_str(),right->title.c_str());
	if (res < 0) return true;
	return false;
}

bool SortGenres(const GenreItem * left, const GenreItem * right) 
{ 
	int res = _wcsicmp(left->title.c_str(),right->title.c_str());
	if (res < 0) return true;
	return false;
}

void ContentList::SortAll()
{
	sort(Content.begin(), Content.end(),SortContent);
	for (int i = 0 ; i < 6 ; i++)
	{
		vector<GenreItem*> * l = Genres[i];
		sort(l->begin(), l->end(),SortGenres);
	}
}

void ContentList::LoadConfig()
{
	for (int i = 0 ; i < 6 ; i++)
	{
		TypePaths * l = new TypePaths();
		Paths[i] = l;
	}

	XMLReader * xml = LoadConfigFile(datapath + L"config.xml");
//	char temp[1024];
	DebugMsg("Loading Config");
	while (xml && xml->read())
	{
		if (StartAttribute(xml,L"display"))
		{
			HorizOverscan = xml->getAttributeValueAsInt(L"horizoverscan");
			HOverscan = HorizOverscan;
			VertOverscan = xml->getAttributeValueAsInt(L"vertoverscan");
			VOverscan = VertOverscan;
		}

		if (StartAttribute(xml,L"xbox360"))
		{
			TypePaths * l = Paths[1];
			while (!EndAttribute(xml,L"xbox360"))
			{
				if (StartAttribute(xml,L"path"))
				{
					wstring path = xml->getSubNodeData();
					l->path.push_back(path);
					DebugMsg("Adding path %S",path.c_str());
					//sprintf_s(temp,1024,"xbox360 : %s",*(l->path.back()).c_str());
					//debugLog(temp);
				}
			}
		}

		if (StartAttribute(xml,L"xbox1"))
		{
			TypePaths * l = Paths[2];
			while (!EndAttribute(xml,L"xbox1"))
			{
				if (StartAttribute(xml,L"path"))
				{
					l->path.push_back(xml->getSubNodeData());
					//sprintf_s(temp,1024,"xbox1 : %s",*(l->path.back()).c_str());
					//debugLog(temp);
				}
			}
		}

		if (StartAttribute(xml,L"homebrew"))
		{
			TypePaths * l = Paths[3];
			while (!EndAttribute(xml,L"homebrew"))
			{
				if (StartAttribute(xml,L"path"))
				{
					l->path.push_back(xml->getSubNodeData());
					//sprintf_s(temp,1024,"homebrew : %s",*(l->path.back()).c_str());
					//debugLog(temp);
				}
			}
		}

		if (StartAttribute(xml,L"emulators"))
		{
			TypePaths * l = Paths[4];
			while (!EndAttribute(xml,L"emulators"))
			{
				if (StartAttribute(xml,L"path"))
				{
					l->path.push_back(xml->getSubNodeData());
					//sprintf_s(temp,1024,"emulators : %s",*(l->path.back()).c_str());
					//debugLog(temp);
				}
			}
		}

		if (StartAttribute(xml,L"xboxlive"))
		{
			TypePaths * l = Paths[0];
			while (!EndAttribute(xml,L"xboxlive"))
			{
				if (StartAttribute(xml,L"path"))
				{
					l->path.push_back(xml->getSubNodeData());
					//sprintf_s(temp,1024,"xboxlive : %s",*(l->path.back()).c_str());
					//debugLog(temp);
				}
			}
		}

		if (StartAttribute(xml,L"gamelistopt"))
		{
			UseBackgrounds = xml->getAttributeValueAsInt(L"background");
			SemiTransparentBackground = xml->getAttributeValueAsInt(L"semitransparent");
			UsePreviews = xml->getAttributeValueAsInt(L"preview");
		}

		if (StartAttribute(xml,L"mainscreenopt"))
		{
			TempStatus = xml->getAttributeValueAsInt( L"tempstatus");
			Cels = xml->getAttributeValueAsInt( L"celsius");
			DiskStatus = xml->getAttributeValueAsInt( L"diskstatus");
			ParentalControl = xml->getAttributeValueAsInt( L"parent");
			ShowIP = xml->getAttributeValueAsInt( L"showip");
			ShowStatus = xml->getAttributeValueAsInt( L"showstatus");
		}

		if (StartAttribute(xml,L"moreoptions"))
		{
			FanSpeed = xml->getAttributeValueAsInt( L"fanspeed");
			FSpeed = FanSpeed;
			LedType = xml->getAttributeValueAsInt(L"ledformat");
		}

		if (StartAttribute(xml,L"timeformat"))
		{
			TimeFormat = xml->getAttributeValueAsInt(L"time");
			DateFormat = xml->getAttributeValueAsInt(L"date");

			NTPonStartup = xml->getAttributeValueAsInt(L"ntp");
		}
		if (StartAttribute(xml,L"skin"))
		{
			skin = xml->getSubNodeData();
		}

	/*<ftp xboxip="192.168.1.66" port="21" username="xbox" password="xbox" />
	<debug host="192.168.1.6" port="22597" />*/
		if (StartAttribute(xml,L"ftp"))
		{
			xboxip = xml->getAttributeValue(L"xboxip");
			port = xml->getAttributeValueAsInt(L"port");
			ftpuser = xml->getAttributeValue(L"username");
			ftppass = xml->getAttributeValue(L"password");
		}

		if (StartAttribute(xml,L"debug"))
		{
			debugip = xml->getAttributeValue(L"host");
			debugport = xml->getAttributeValueAsInt(L"port");
		}

	}
}

void ContentList::ClearDeleted()
{
	vector<ContentItem*>::iterator itr;
	for (itr = Content.begin() ; itr != Content.end() ; )
	{
		ContentItem * item = (*itr);
		if (!item->Exist)
		{
			delete item;
			itr = Content.erase(itr);
			AnyChanged = true;
		} else {
			itr++;
		}
	}

}

void ContentList::LoadNonXMLItems()
{
	int PathCount = 0;
	for (int i = 0 ; i < 6 ; i++)
	{
		TypePaths * l = Paths[i];
		vector <wstring>::iterator itr;
		for (itr = l->path.begin() ; itr != l->path.end() ; itr++)
		{
			PathCount++;
		}
	}
	sub1ProgMax = PathCount;
	sub1ProgCur = 0;
	for (int i = 0 ; i < 6 ; i++)
	{
		TypePaths * l = Paths[i];
		vector <wstring>::iterator itr;
		for (itr = l->path.begin() ; itr != l->path.end() ; itr++)
		{
			wstring path = (*itr);

			SetSub1(path);

			if (i == 0)
			{
				ScanXBLAPath(i,path);
			} else {
				ScanPath(i,path);
			}
			sub1ProgCur++;
		}
	}
	SetSub1(L"");
	SetSub2(L"");
	sub1ProgMax = 0;
	sub2ProgMax = 0;
}

void ContentList::ScanPath(int type, wstring path)
{
	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	wstring searchcmd = path + L"\\*";
	searchcmd = str_replaceall(searchcmd,L"\\\\",L"\\");
	HANDLE hFind = FindFirstFile(wstrtostr(searchcmd).c_str(), &findFileData);
	if (hFind == INVALID_HANDLE_VALUE)
		return;

	int SubDirCount = 0;
	do {
		SubDirCount++;
	} while (FindNextFile(hFind, &findFileData));
	FindClose(hFind);

	sub2ProgMax = SubDirCount;
	sub2ProgCur = 0;

	hFind = FindFirstFile(wstrtostr(searchcmd).c_str(), &findFileData);

	do {
		wstring s = strtowstr(findFileData.cFileName);
		SetSub2(strtowstr(findFileData.cFileName));

		wstring thispath = path + L"\\" + s;
		thispath = str_replaceall(thispath,L"\\\\",L"\\");

		map<wstring,ContentItem*>::iterator itr;
		wstring thispath2 = make_lowercase(thispath);
		itr = PathLookup.find(thispath2);
		if (itr != PathLookup.end())
		{
			//DebugMsg("Skipping %d path %s",type,thispath);
			(*itr).second->Exist = true;
		} else {
			//DebugMsg("Scanning %d path %s",type,thispath);
			if (type == 2)
			{
				ScanGame(type,thispath,L"default.xbe");
			} else if (type == 0 || type == 1) {
				ScanGame(type,thispath,L"default.xex");
			} else {
				ScanGame(type,thispath,L"*.xex");
			}
		}

		sub2ProgCur++;

	} while (FindNextFile(hFind, &findFileData));
	FindClose(hFind);
}

void ContentList::ScanGame(int type, wstring path, wstring search)
{
	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	wstring searchcmd = path + L"\\" + search;
	searchcmd = str_replaceall(searchcmd,L"\\\\",L"\\");
	HANDLE hFind = FindFirstFile(wstrtostr(searchcmd).c_str(), &findFileData);
	if (hFind == INVALID_HANDLE_VALUE)
		return;

	do {
		wstring s = strtowstr(findFileData.cFileName);

		wstring file = path + L"\\" + s;
		wstring lastfolder = path.substr(path.rfind(L"\\")+1);
		ContentItem * item = new ContentItem();
		item->path = file;
		item->title = lastfolder;
		item->type = type;
		item->c_type = type;
		item->source = 2;
		item->imagefolder = lastfolder;
		item->Exist = true;
		
		MakeShortPath(item);

		AnyChanged = true;

		if (make_lowercase(FileExt(s)) == L"xex")
		{
			XEXParse(item);
		}

		wstring nxeartfile = path + L"\\nxeart";

		if (FileExists(nxeartfile))
		{
			DebugMsg("Extracting icon from %s",nxeartfile.c_str());

			if (!FileExists(datapath + L"artwork"))
				_wmkdir(wstring(datapath + L"artwork").c_str());
			if (!FileExists(datapath + L"artwork\\" + item->imagefolder))
				_wmkdir(wstring(datapath + L"artwork\\" + item->imagefolder).c_str());

			wstring outfile = datapath + L"artwork\\" + item->imagefolder + L"\\icon.png";

			if (!FileExists(outfile))
			{
				if (ExtractLiveImage(outfile,nxeartfile,0))
				{
					item->i_Icon = true;
				}
			} else {
				item->i_Icon = true;
			}
		}

		Content.push_back(item);
	} while (FindNextFile(hFind, &findFileData));
	FindClose(hFind);
	
}

void swapbytes(int * temp)
{
	char * buf = (char *)temp;
	char a;
	a = buf[0];
	buf[0] = buf[3];
	buf[3] = a;
	a = buf[2];
	buf[2] = buf[1];
	buf[1] = a;
}

struct xex_rec {
	int var1;
	int var2;
};

struct header_1 {
	int mediaid;
	int version1;
	int version2;
	int titleid;
	char unused;
	char unused2;
	char diskno;
	char diskcount;
};

void ContentList::XEXParse(ContentItem * item)
{
	if (item->type != 1)
		return;

	FILE * fp = NULL;
	DebugMsg("Parsing XEX %s",item->path.c_str());

	_wfopen_s(&fp,item->path.c_str(),L"rb");
	if (!fp)
		return;


	fseek(fp,0x14,SEEK_SET);
	int temp = 0;
	fread(&temp,4,1,fp);
	//swapbytes(&temp);

	if (temp > 50)
	{
		DebugMsg("temp too large = %08x",temp);
		fclose(fp);
		return;
	}

	xex_rec * recs = new xex_rec[temp];

	fread(recs,sizeof(xex_rec),temp,fp);

	int headeraddy = 0;

	for (int i = 0 ; i < temp ; i++)
	{
		//swapbytes(&recs[i].var1);
		//swapbytes(&recs[i].var2);

		if (recs[i].var1 == 0x00040006)
		{
			headeraddy = recs[i].var2;
		}
	}

	if (headeraddy > 0x30000 || headeraddy < 0x100)
	{
		DebugMsg("invalid header offset = %08x",headeraddy);
		fclose(fp);
		return;
	}
	fseek(fp,headeraddy,SEEK_SET);

	header_1 header;
	fread(&header,sizeof(header),1,fp);

	DebugMsg("Got %08x, %08x, version %d, %d, Disk %d of %d",header.mediaid, header.titleid, header.version1, header.version2, header.diskno, header.diskcount);

	item->id = sprintfa(L"%08x",header.titleid);
	item->mediaid = sprintfa(L"%08x",header.mediaid);
	item->version = header.version1;
	item->discno = header.diskno;
	item->disccn = header.diskcount;

	fclose(fp);
}

void ContentList::ScanXBLAPath(int type, wstring path)
{
   WIN32_FIND_DATA findFileData;
   memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
   wstring searchcmd = path + L"\\0000000000000000\\*.*";
   searchcmd = str_replaceall(searchcmd,L"\\\\",L"\\");
   HANDLE hFind = FindFirstFile(wstrtostr(searchcmd).c_str(), &findFileData);
   if (hFind == INVALID_HANDLE_VALUE)
      return;

   int SubDirCount = 0;
   do {
      SubDirCount++;
   } while (FindNextFile(hFind, &findFileData));
   FindClose(hFind);

   hFind = FindFirstFile(wstrtostr(searchcmd).c_str(), &findFileData);

   sub2ProgMax = SubDirCount;
   sub2ProgCur = 0;

   do {
      SetSub2(strtowstr(findFileData.cFileName));
      map<wstring,ContentItem*>::iterator itr;
      wstring thispath = make_lowercase(strtowstr(findFileData.cFileName));
      itr = PathLookup.find(thispath);
      if (itr != PathLookup.end())
      {
         //DebugMsg("Skipping XBLA path %s (%s\\0000000000000000\\%s)",findFileData.cFileName,path.c_str(),findFileData.cFileName);
         (*itr).second->Exist = true;
      } else {
         //DebugMsg("Scanning XBLA path %s (%s\\0000000000000000\\%s)",findFileData.cFileName,path.c_str(),findFileData.cFileName);
         ScanXBLAGame(0,path,strtowstr(findFileData.cFileName));
         ScanGODGame(5,path,strtowstr(findFileData.cFileName));
		 ScanXBOX1GOD(6,path,strtowstr(findFileData.cFileName));
      }
      sub2ProgCur++;

   } while (FindNextFile(hFind, &findFileData));
   FindClose(hFind);
}

void ContentList::ScanXBOX1GOD(int type, wstring path, wstring id)
{
   WIN32_FIND_DATA findFileData;
   memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
   wstring searchcmd = path + L"\\0000000000000000\\" + id + L"\\00005000\\*";
   searchcmd = str_replaceall(searchcmd,L"\\\\",L"\\");
       
   HANDLE hFind = FindFirstFile(wstrtostr(searchcmd).c_str(), &findFileData);
   if (hFind == INVALID_HANDLE_VALUE)
      return;
            do {
      if (findFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
      {
      } else {
         wstring s = strtowstr(findFileData.cFileName);
         ContentItem * item = new ContentItem();
         item->path = sprintfa(L"%s0000000000000000\\%s\\00005000\\%s",path.c_str(),id.c_str(),s.c_str());
         //DebugMsg("Adding XBLX %s",item->path.c_str());
         item->type = type;
		 item->c_type = type;
         item->id = id;
         item->Exist = true;
         item->source = 3;
         item->imagefolder = id;
         MakeShortPath(item);
         AnyChanged = true;
         GODParse(item);
         Content.push_back(item);
      }
      } while (FindNextFile(hFind, &findFileData));

      FindClose(hFind);
   }

void ContentList::ScanGODGame(int type, wstring path, wstring id)
{
   WIN32_FIND_DATA findFileData;
   memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
   wstring searchcmd = path + L"\\0000000000000000\\" + id + L"\\00007000\\*";
   searchcmd = str_replaceall(searchcmd,L"\\\\",L"\\");
       
   HANDLE hFind = FindFirstFile(wstrtostr(searchcmd).c_str(), &findFileData);
   if (hFind == INVALID_HANDLE_VALUE)
      return;
            do {
      if (findFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
      {
      } else {
         wstring s = strtowstr(findFileData.cFileName);
         ContentItem * item = new ContentItem();
         item->path = sprintfa(L"%s0000000000000000\\%s\\00007000\\%s",path.c_str(),id.c_str(),s.c_str());
         //DebugMsg("Adding XBLX %s",item->path.c_str());
         item->type = type;
		 item->c_type = type;

         item->id = id;
         item->Exist = true;
         item->source = 3;
         item->imagefolder = id;
         MakeShortPath(item);
         AnyChanged = true;
         GODParse(item);
         Content.push_back(item);
      }
      } while (FindNextFile(hFind, &findFileData));

      FindClose(hFind);
   }
void ContentList::ScanXBLAGame(int type, wstring path, wstring id)
{
	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	wstring searchcmd = path + L"\\0000000000000000\\" + id + L"\\000D0000\\*";
	searchcmd = str_replaceall(searchcmd,L"\\\\",L"\\");
	HANDLE hFind = FindFirstFile(wstrtostr(searchcmd).c_str(), &findFileData);
	if (hFind == INVALID_HANDLE_VALUE)
		return;

	do {
		wstring s = strtowstr(findFileData.cFileName);

		ContentItem * item = new ContentItem();
		item->path = sprintfa(L"%s0000000000000000\\%s\\000D0000\\%s",path.c_str(),id.c_str(),s.c_str());
		//DebugMsg("Adding XBLX %s",item->path.c_str());
		item->type = type;
		item->c_type = type;
		item->id = id;
		item->Exist = true;
		item->source = 3;
		item->imagefolder = id;

		MakeShortPath(item);

		AnyChanged = true;

		XBLAParse(item);

		Content.push_back(item);
	} while (FindNextFile(hFind, &findFileData));

	FindClose(hFind);
}

void ContentList::XBLAParse(ContentItem * item)
{
	//DebugMsg("Parsing XBLA %s",item->path.c_str());
	FILE * fp = NULL;
	_wfopen_s(&fp,item->path.c_str(),L"rb");
	if (!fp)
	{
		DebugMsg("Unable to open %S",item->path.c_str());
		return;
	}
	byte k[4];


	fseek(fp,0x344,SEEK_SET);
	fread((void*)(&k),4,1,fp);
	item->packagetype = sprintfa(L"%02x%02x%02x%02x",k[0],k[1],k[2],k[3]);

	if (item->packagetype != L"000d0000")
	{
		DebugMsg("Not Arcade game -> %S",item->packagetype.c_str());
		fclose(fp);
		return;
	}

	fseek(fp,0x360,SEEK_SET);
	fread((void*)(&k),4,1,fp);
//	item->id = sprintfa(L"%02x%02x%02x%02x",k[0],k[1],k[2],k[3]);

	WCHAR title[0x400];
	memset(title,0,0x400);
	fseek(fp,0x411,SEEK_SET);
	fread((void*)(&title),2,0xFF,fp);

	item->title = title;
	item->title = str_replaceall(item->title,L"\"",L"");

	fclose(fp);


	if (!FileExists(datapath + L"artwork"))
		_wmkdir(wstring(datapath + L"artwork").c_str());
	if (!FileExists(datapath + L"artwork\\" + item->imagefolder))
		_wmkdir(wstring(datapath + L"artwork\\" + item->imagefolder).c_str());

	wstring outfile = datapath + L"artwork\\" + item->imagefolder + L"\\icon.png";

	if (!FileExists(outfile))
	{
		if (ExtractLiveImage(outfile,item->path,0))
		{
			item->i_Icon = true;
		}
	} else {
		item->i_Icon = true;
	}
}
void ContentList::GODParse(ContentItem * item)
{
   //DebugMsg("Parsing GOD %s",item->path.c_str());
   FILE * fp = NULL;
   _wfopen_s(&fp,item->path.c_str(),L"rb");
   if (!fp)
   {
      DebugMsg("Unable to open %S",item->path.c_str());
      return;
   }
   byte k[4];


   fseek(fp,0x344,SEEK_SET);
   fread((void*)(&k),4,1,fp);
   item->packagetype = sprintfa(L"%02x%02x%02x%02x",k[0],k[1],k[2],k[3]);

   if (item->packagetype != L"00007000")
   {
      DebugMsg("Not GOD game -> %S",item->packagetype.c_str());
      fclose(fp);
      return;
   }

   fseek(fp,0x360,SEEK_SET);
   fread((void*)(&k),4,1,fp);
//   item->id = sprintfa(L"%02x%02x%02x%02x",k[0],k[1],k[2],k[3]);

   WCHAR title[0x400];
   memset(title,0,0x400);
   fseek(fp,0x411,SEEK_SET);
   fread((void*)(&title),2,0xFF,fp);

   item->title = title;
   item->title = str_replaceall(item->title,L"\"",L"");

   fclose(fp);


   if (!FileExists(datapath + L"artwork"))
      _wmkdir(wstring(datapath + L"artwork").c_str());
   if (!FileExists(datapath + L"artwork\\" + item->imagefolder))
      _wmkdir(wstring(datapath + L"artwork\\" + item->imagefolder).c_str());

   wstring outfile = datapath + L"artwork\\" + item->imagefolder + L"\\icon.png";

   if (!FileExists(outfile))
   {
      if (ExtractLiveImage(outfile,item->path,0))
      {
         item->i_Icon = true;
      }
   } else {
      item->i_Icon = true;
   }
}

void ContentList::XBOX1Parse(ContentItem * item)
{
   //DebugMsg("Parsing GOD %s",item->path.c_str());
   FILE * fp = NULL;
   _wfopen_s(&fp,item->path.c_str(),L"rb");
   if (!fp)
   {
      DebugMsg("Unable to open %S",item->path.c_str());
      return;
   }
   byte k[4];


   fseek(fp,0x344,SEEK_SET);
   fread((void*)(&k),4,1,fp);
   item->packagetype = sprintfa(L"%02x%02x%02x%02x",k[0],k[1],k[2],k[3]);

   if (item->packagetype != L"00005000")
   {
      DebugMsg("Not GOD game -> %S",item->packagetype.c_str());
      fclose(fp);
      return;
   }

   fseek(fp,0x360,SEEK_SET);
   fread((void*)(&k),4,1,fp);
//   item->id = sprintfa(L"%02x%02x%02x%02x",k[0],k[1],k[2],k[3]);

   WCHAR title[0x400];
   memset(title,0,0x400);
   fseek(fp,0x411,SEEK_SET);
   fread((void*)(&title),2,0xFF,fp);

   item->title = title;
   item->title = str_replaceall(item->title,L"\"",L"");

   fclose(fp);


   if (!FileExists(datapath + L"artwork"))
      _wmkdir(wstring(datapath + L"artwork").c_str());
   if (!FileExists(datapath + L"artwork\\" + item->imagefolder))
      _wmkdir(wstring(datapath + L"artwork\\" + item->imagefolder).c_str());

   wstring outfile = datapath + L"artwork\\" + item->imagefolder + L"\\icon.png";

   if (!FileExists(outfile))
   {
      if (ExtractLiveImage(outfile,item->path,0))
      {
         item->i_Icon = true;
      }
   } else {
      item->i_Icon = true;
   }
}
bool ContentList::ExtractLiveImage(wstring destfile, wstring sourcefile, int whichimg)
{
	//DebugMsg("ExtractLiveImage %s -> %s",sourcefile.c_str(), destfile.c_str());

	byte* buffer = new byte[100000];

	FILE * fp = 0;

	_wfopen_s(&fp,sourcefile.c_str(),L"rb");
	if (fp)
	{
		memset(buffer,0,sizeof(buffer));

		fseek(fp,0,SEEK_SET);
		int read = fread(buffer,1,100000,fp);

		int size = 0;
		int start = 0;

		int imgno = 0;
		for (int i = 0 ; i < read - 4 ; i++)
		{
			if (buffer[i] == 0x89 && buffer[i+1] == 0x50 && buffer[i+2] == 0x4e && buffer[i+3] == 0x47)
			{
				if (imgno == whichimg)
				{
					start = i;
					break;
				} else {
					imgno++;
				}
			}
		}

		for (int i = start ; i < read - 4 ; i++)
		{
			if (buffer[i] == 0x49 && buffer[i+1] == 0x45 && buffer[i+2] == 0x4e && buffer[i+3] == 0x44)
			{
				size = i + 8;
				break;
			}
		}

		fclose(fp);

		if (size > 0)
		{
			DebugMsg("Saving icon as %s, offset %d, size %d",destfile.c_str(),start,size);
			FILE * ofp = 0;
			_wfopen_s(&ofp,destfile.c_str(),L"wb");

			if (ofp)
			{
				fwrite(buffer+start,1,size,ofp);
				fclose(ofp);
			}

			return true;
		} else {
			DebugMsg("No icon found in %s",sourcefile.c_str()); 
		}
	} else {
		DebugMsg("Unable to open file");
	}

	return false;
}

void ContentList::BuildGenreList()
{
	//DebugMsg("Building Genre List");
	for (int i = 0 ; i < 6 ; i++)
	{
		vector <GenreItem*> * l = new vector <GenreItem*>;
		Genres[i] = l;
	}

	vector <ContentItem*>::iterator itr;
	for (itr = Content.begin() ; itr != Content.end() ; itr++)
	{
		ContentItem * item = (*itr);
		//DebugMsg("Item %s",item->title.c_str());
		vector <wstring>::iterator gi;

		vector <GenreItem*> * l = Genres[item->type];

		for (gi = item->genres.begin() ; gi != item->genres.end() ; gi++)
		{
			wstring genre = (*gi);
			//DebugMsg("Genre %s",wstrtostr(genre).c_str());
			
			bool found = false;
			vector <GenreItem*>::iterator fi;
			for (fi = l->begin() ; fi != l->end() ; fi++)
			{
				GenreItem* git = (*fi);
				if (git->title == genre)
				{
					found = true;
					break;
				}
			}

			if (!found)
			{
				GenreItem* item = new GenreItem();
				item->title = genre;
				l->push_back(item);
			}		
		}
	}
}

ContentItems* ContentList::GetItems(int type,wstring genre,bool OnlyFavs,bool OnlyRecent)
{
	ContentItems * result = new ContentItems();
	//result.pItems = new ContentItem[Content.size()];
	vector <ContentItem*>::iterator itr;

	memset(result->pItems,0,1000);
	int count = 0;

	if (OnlyRecent)
		sort(Content.begin(), Content.end(),SortRecent);


	for (itr = Content.begin() ; itr != Content.end() ; itr++)
	{
		ContentItem * item = (*itr);

		if (item->c_type != 5 && item->c_type != 6) 
		{ 
			if (type != -1 && item->c_type != type) 
				continue; 
		} else if (item->c_type == 5 && type != 1 && type != -1) {
			continue; 
		} else if (item->c_type == 6 && type != 2 && type != -1) {
			continue;
		}
 
 


		if (OnlyFavs && !item->Favourite)
			continue;

		if (OnlyRecent && item->recent == 0)
			continue;

		if (genre.empty())
		{
			result->pItems[count] = item;
			count++;
		} else {
			vector<wstring>::iterator gi;
			for (gi = item->genres.begin() ; gi != item->genres.end() ; gi++)
			{
				wstring itemgenre = (*gi);
				if (itemgenre == genre)
				{
					result->pItems[count] = item;
					count++;
				}
			}
		}
	}
	result->nItems = count;

	if (OnlyRecent)
		sort(Content.begin(), Content.end(),SortContent);

	DebugMsg("ContentList::GetItems(%d,%s,%d) returning %d items",type,wstrtostr(genre).c_str(),OnlyFavs,count);
	return result;
}

GenreItems* ContentList::GetGenres(int type)
{
	DebugMsg("Getting genres %d",type);

	GenreItems * result = new GenreItems();
	//result.pItems = new ContentItem[Content.size()];
	vector <GenreItem*>::iterator itr;

	memset(result->pItems,0,100);
	int count = 0;
	vector <GenreItem*> * l = Genres[type];
	vector <GenreItem*>::iterator fi;
	for (fi = l->begin() ; fi != l->end() ; fi++)
	{
		GenreItem * item = (*fi);
		result->pItems[count] = item;
		string temp = wstrtostr(item->title);
		DebugMsg(temp.c_str());
		count++;
	}

	result->nItems = count;

	return result;
}

wstring ContentList::GetGameList(int type, wstring genre)
{
	wstring gamelist;
	vector <ContentItem*>::iterator itr;
	for (itr = Content.begin() ; itr != Content.end() ; itr++)
	{
		ContentItem * item = (*itr);

		if (item->type != type)
			continue;

		bool goodgame = false;

		vector<wstring>::iterator gi;
		for (gi = item->genres.begin() ; gi != item->genres.end() ; gi++)
		{
			wstring itemgenre = (*gi);
			if (itemgenre == genre)
				goodgame = true;
		}

		if (goodgame)
		{
			gamelist.append(item->title);
			gamelist.append(L"\n");
		}
	}

	return gamelist;
}

void ContentList::LoadFavourites()
{
	XMLReader * xml = LoadConfigFile(datapath + L"config.xml");

	//lock->Lock();
	//lock->Unlock();
	//debugLog("USED PATHS:");
	while (xml && xml->read())
	{
		if (StartAttribute(xml,L"fav"))
		{
			wstring path = xml->getSubNodeData();

			map<wstring,ContentItem*>::iterator itr;
			itr = PathLookup.find(path);
			if (itr != PathLookup.end())
				PathLookup[path]->Favourite = true;
		}
		if (StartAttribute(xml,L"recent"))
		{
			wstring path = xml->getSubNodeData();

			map<wstring,ContentItem*>::iterator itr;
			itr = PathLookup.find(path);
			if (itr != PathLookup.end())
			{
				PathLookup[path]->recent = xml->getAttributeValueAsInt(L"no");
				if (LastRecent < PathLookup[path]->recent)
					LastRecent = PathLookup[path]->recent;
			}
		}
	} 
	
	FreeXMLAndText(xml);
}

void ContentList::SortMaxRecents()
{
	map <int, ContentItem *> RecentGames;
	vector<ContentItem*>::iterator itr;
	for (itr = cl.Content.begin() ; itr != cl.Content.end() ; itr++)
	{
		ContentItem * it = (*itr);
		if (it->recent > 0)
		{
			RecentGames[it->recent] = it;
		}
	}

	DebugMsg("Recent Games: ");
	map <int, ContentItem *>::iterator it2;
	for (it2 = RecentGames.begin() ; it2 != RecentGames.end() ; it2++)
	{
		DebugMsg("%d - %s",(*it2).second->recent,(*it2).second->shortpath.c_str());
	}

	while (RecentGames.size() > 15)
	{
		it2 = RecentGames.begin();
		(*it2).second->recent = 0;

		RecentGames.clear();
		for (itr = cl.Content.begin() ; itr != cl.Content.end() ; itr++)
		{
			ContentItem * it = (*itr);
			if (it->recent > 0)
			{
				RecentGames[it->recent] = it;
			}
		}
	}
}

void ContentList::LaunchGame(ContentItem * item)
{
	LastRecent++;
	item->recent = LastRecent;

	SortMaxRecents();

	DoSaveSettings();

	//Reset LED to factory if in Temp Mode
	if(LedType == 1)
	{
		SetLedState(0);
	}

	wstring filetorun = make_lowercase(item->path);
	wstring ext = FileExt(filetorun);
	if (ext == L"xex")
	{
		//DebugMsg("Launching XEX %s",item->path.c_str());
		XLaunchNewImage(wstrtostr(item->path).c_str(), 0);
	} else if (ext == L"xbe") 
	{
		//DebugMsg("Launching XBE %s",item->path.c_str());
		XLaunchNewImage(wstrtostr(item->path).c_str(), 0);
	} else {
		//DebugMsg("Launching XBLA %s",item->path.c_str());

		string drive = wstrtostr(item->path.substr(0,item->path.find(L":")+1));
		string folder = wstrtostr(item->path.substr(item->path.find(L":")+2));
		u32 ret;

		//DebugMsg("XBLA : drive : \"%s\"",drive.c_str());
		//DebugMsg("XBLA : folder : \"%s\"",folder.c_str());
		
		char mntpth[] = "dice";
		char drive_s[256];
		strcpy_s(drive_s, 256, drive.c_str());

		char folder_s[1024];
		strcpy_s(folder_s, 1024, folder.c_str());

		ret = mountCon(mntpth, drive_s, folder_s);

		//DebugMsg("Mount XBLA returns %d",ret);
		if (FileExistsA("dice:\\default.xex"))
		{
			XLaunchNewImage("dice:\\default.xex", 0);
		}

        XLaunchNewImage("dice:\\default.xbe", 0);
	}
}